-- Copyright (c) 2019 Broadcom. All Rights Reserved.
-- The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
--
-- THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
-- BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
-- EXPRESS WRITTEN PERMISSION OF BROADCOM.
--
-- The Licensed Software and Documentation are deemed to be commercial computer
-- software as defined in FAR 12.212 and subject to restricted rights as
-- defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
-- Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
-- Commercial Computer Software Documentation," as applicable, and any successor
-- regulations, whether delivered by Broadcom as on premises or hosted services.
-- Any use, modification, reproduction release, performance, display or
-- disclosure of the Licensed Software and Documentation by the U.S. Government
-- shall be solely in accordance with the terms of this Agreement.

Set Verify OFF;
ACCEPT syspass PROMPT 'Enter the password for sys user: ' hide
ACCEPT sid DEFAULT 'protect'  PROMPT 'Enter sid [default - protect]: '
ACCEPT view_username DEFAULT 'icdx_user'  PROMPT 'Enter user name to be created [default - icdx_user]: '
ACCEPT view_pass PROMPT 'Enter a password for the new user: ' hide

connect sys/&syspass@ &sid as sysdba;



-- ----------------------------------------------------------------------
-- Additional Steps.
-- ----------------------------------------------------------------------

ALTER PROFILE DEFAULT LIMIT PASSWORD_LIFE_TIME unlimited;

DROP USER &view_username CASCADE;

-- ----------------------------------------------------------------------
-- Create the &view_username user
-- ----------------------------------------------------------------------
CREATE USER &view_username IDENTIFIED BY &view_pass;
ALTER USER  &view_username DEFAULT   TABLESPACE users;
ALTER USER  &view_username TEMPORARY TABLESPACE temp;

-- ----------------------------------------------------------------------
-- These grants make up the connect role:
-- ----------------------------------------------------------------------
GRANT
create session
,alter session
,create synonym
,create view
TO &view_username;

GRANT SELECT ON V_$SESSION TO &view_username;
GRANT SELECT ON V_$INSTANCE TO &view_username;

exit;