-- Copyright (c) 2019 Broadcom. All Rights Reserved.
-- The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
--
-- THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
-- BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
-- EXPRESS WRITTEN PERMISSION OF BROADCOM.
--
-- The Licensed Software and Documentation are deemed to be commercial computer
-- software as defined in FAR 12.212 and subject to restricted rights as
-- defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
-- Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
-- Commercial Computer Software Documentation," as applicable, and any successor
-- regulations, whether delivered by Broadcom as on premises or hosted services.
-- Any use, modification, reproduction release, performance, display or
-- disclosure of the Licensed Software and Documentation by the U.S. Government
-- shall be solely in accordance with the terms of this Agreement.

CREATE OR REPLACE VIEW DISCOVER_TARGETS AS
   SELECT SCANASSIGNMENTID              AS DISCOVER_TARGET_ID,
          NAME                          AS TARGET_NAME,
          TARGETTYPE                    AS TARGET_TYPE
   FROM   SCANASSIGNMENT;

CREATE OR REPLACE VIEW DISCOVER_VIOLATIONS AS
   SELECT DV.DISCOVERVIOLATIONID           AS DISCOVER_VIOLATION_ID,
          DV.POLICYID                      AS POLICY_ID,
          DV.SCANASSIGNMENTID              AS DISCOVER_TARGET_ID,
          DV.DETECTEDREMEDIATIONTYPE       AS REMEDIATION_TYPE,
          DV.REMEDIATIONDETECTIONDATE      AS REMEDIATION_DETECTION_DATE
   FROM   DISCOVERVIOLATION DV;

CREATE OR REPLACE VIEW DISCOVER_CONTENT_ORIGINATORS AS
   SELECT MESSAGEORIGINATORID     AS DISCOVER_CONTENT_ORIGINATOR_ID,
          NETWORKSENDERIDENTIFIER AS SENDER_IDENTIFIER
   FROM   MESSAGEORIGINATOR;

CREATE OR REPLACE VIEW DISCOVER_CONTENT_RECIPIENTS AS
   SELECT MESSAGERECIPIENTID      AS DISCOVER_CONTENT_RECIPIENT_ID,
          MESSAGEID               AS DISCOVER_CONTENT_ID,
          RECIPIENTIDENTIFIER     AS RECIPIENT_IDENTIFIER,
          RECIPIENTTYPE           AS RECIPIENT_TYPE
   FROM   MESSAGERECIPIENT;

CREATE OR REPLACE VIEW DISCOVER_ACL_ENTRIES AS
   SELECT MESSAGEACLENTRYID       AS DISCOVER_ACL_ENTRY_ID,
          MESSAGEID               AS DISCOVER_CONTENT_ID,
          PRINCIPAL               AS FILE_PERMISSION_NAME,
          ACLTYPE                 AS ACL_TYPE,
          GRANTDENY               AS GRANT_OR_DENY,
          PERMISSION              AS PERMISSION
   FROM   MESSAGEACLENTRY;


CREATE OR REPLACE VIEW DISCOVER_CONTENT_COMPONENTS AS
   SELECT MESSAGECOMPONENTID      AS DISCOVER_CONTENT_COMPONENT_ID,
          MESSAGEID               AS DISCOVER_CONTENT_ID,
          NAME                    AS ATTACHMENT_NAME,
          MIMETYPE                AS MIME_TYPE,
          COMPONENTTYPE           AS COMPONENT_TYPE,
          ORIGINALSIZE            AS ORIGINAL_SIZE
   FROM   MESSAGECOMPONENT;

CREATE OR REPLACE VIEW DISCOVER_CONDITION_VIOLATIONS AS
   SELECT CV.CONDITIONVIOLATIONID    AS DISCOVER_CONDITION_VIO_ID,
          CV.VIOLATIONCOUNT          AS CONDITION_VIOLATION_COUNT,
          CV.MESSAGECOMPONENTID      AS DISCOVER_CONTENT_COMPONENT_ID,
          CV.INCIDENTID              AS DISCOVER_INCIDENT_ID,
          C.NAME                     AS POLICY_CONDITION_NAME,
          C.TYPE                     AS POLICY_CONDITION_TYPE
   FROM   CONDITIONVIOLATION CV,
          CONDITIONVIEW C
   WHERE  CV.CONDITIONID = C.CONDITIONID;

CREATE OR REPLACE VIEW DISCOVER_CONTENTS AS
   SELECT M.MESSAGEID                      AS DISCOVER_CONTENT_ID,
          M.MONITORID                      AS DETECTION_SERVER_ID,
          M.MESSAGEORIGINATORID            AS DISCOVER_CONTENT_ORIGINATOR_ID,
          M.DISCOVERSCANASSIGNMENTID       AS DISCOVER_TARGET_ID,
          W.STARTDATE                      AS SCAN_DATE,
          M.MESSAGEDATE                    AS EVENT_DATE,
          W.ELAPSEDTIME                    AS ELAPSED_TIME,
          M.FILECREATEDATE                 AS FILE_CREATED_DATE,
          M.FILEACCESSDATE                 AS FILE_ACCESSED_DATE,
          M.FILECREATEDBY                  AS FILE_CREATED_BY,
          M.FILEMODIFIEDBY                 AS FILE_MODIFIED_BY,
          M.FILEOWNER                      AS FILE_OWNER,
          M.DISCOVERURL                    AS RESOURCE_LOCATION,
          M.DISCOVERREMEDIATIONACTION      AS REMEDIATION_ACTION,
          M.DISCOVERNAME                   AS DOCUMENT_NAME,
          M.DISCOVERSERVER                 AS SCANNED_MACHINE,
          M.DISCOVERREPOSITORYLOCATION     AS REPOSITORY_LOCATION,
          M.HASATTACHMENT                  AS HAS_ATTACHMENT,
          M.QUARANTINESTATUS               AS QUARANTINE_STATUS,
          M.MESSAGESUBJECT                 AS SUBJECT
   FROM   MESSAGE M,
          WALK W
   WHERE  MESSAGESOURCE = 'DISCOVER'
   AND    M.DISCOVERWALKID = W.WALKID;

CREATE OR REPLACE VIEW DISCOVER_INCIDENTS AS
   SELECT I.INCIDENTID                      AS DISCOVER_INCIDENT_ID,
          I.MESSAGEID                       AS DISCOVER_CONTENT_ID,
          I.DISCOVERVIOLATIONID             AS DISCOVER_VIOLATION_ID,
          I.INCIDENTSTATUSID                AS INCIDENT_STATUS_ID,
          I.POLICYID                        AS POLICY_ID,
          I.POLICYVERSION                   AS POLICY_VERSION,
          I.POLICYGROUPID                   AS POLICY_GROUP_ID,
          I.CUSTOMATTRIBUTESRECORDID        AS CUSTOM_ATTRIBUTE_ID,
          DO.NAME                           AS DATA_OWNER_NAME,
          DOE.EMAIL                         AS DATA_OWNER_EMAIL,
          I.MESSAGETYPE                     AS EVENT_TYPE_ID,
          I.INCIDENTSEVERITYID              AS INCIDENT_SEVERITY_ID,
          I.DETECTIONDATE                   AS DETECTION_DATE,
          I.MESSAGEDATE                     AS EVENT_DATE,
          I.CREATIONDATE                    AS CREATION_DATE,
          I.VIOLATIONCOUNT                  AS POLICY_VIOLATION_COUNT,
          I.DISCOVERMILLISSINCEFIRSTSEEN    AS MILLIS_SINCE_FIRST_SEEN,
          I.BLOCKEDSTATUS                   AS RESPONSE_ACTION
   FROM   INCIDENT I,
          DATAOWNER DO,
          DATAOWNEREMAIL DOE
   WHERE  MESSAGESOURCE = 'DISCOVER'
   AND    I.DATAOWNERID = DO.DATAOWNERID (+)
   AND    I.DATAOWNEREMAILID = DOE.DATAOWNEREMAILID (+)
   AND    ISDELETED = 0;

CREATE OR REPLACE VIEW DISCOVER_MSG_ITEM_METADATA AS
    SELECT MESSAGEITEMMETADATAID            AS DISCOVER_ITEM_METADATA_ID,
           MESSAGEID                        AS DISCOVER_CONTENT_ID,
           ITEMID                           AS ITEM_ID,
           HASLINK                          AS HAS_LINK,
           PASSWORDPROTECTEDLINK            AS PASSWORD_PROTECTED_LINK,
           LINKEXPIRATIONDATE               AS LINK_EXPIRATION_DATE,
           DOWNLOADALLOWEDLINK              AS DOWNLOAD_ALLOWED_LINK
    FROM   MESSAGEITEMMETADATA;