#!/usr/bin/env bash

# Copyright (c) 2019 Broadcom. All Rights Reserved.
# The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
#
# THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS OF
# BROADCOM. USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
# EXPRESS WRITTEN PERMISSION OF BROADCOM.
#
# The Licensed Software and Documentation are deemed to be commercial computer
# software as defined in FAR 12.212 and subject to restricted rights as
# defined in FAR Section 52.227-19 "Commercial Computer Software - Restricted
# Rights" and DFARS 227.7202, Rights in "Commercial Computer Software or
# Commercial Computer Software Documentation," as applicable, and any successor
# regulations, whether delivered by Broadcom as on premises or hosted services.
# Any use, modification, reproduction release, performance, display or
# disclosure of the Licensed Software and Documentation by the U.S. Government
# shall be solely in accordance with the terms of this Agreement.

set -e

if [[ -z $SYMC_HOME ]]; then
    #              1         2         3         4         5        6          7         8
    #     12345678901234567890123456789012345678901234567890123456789012345678901234567890
    echo "ICDx must install before installing an ICDx application. If you have just"
    echo "installed ICDx, please log out then back in. Otherwise, install ICDx first."
    echo "(The SYMC_HOME environment variable is not set.)"
    exit 1
fi

icdx_user=$(stat -c "%U" "$SYMC_HOME")

if [[ $# -ne 1 ]]; then
    echo "Usage: $0 [application *.tar.gz file]"
    echo "    Installs an ICDx application (collector, forwarder, or action)"
    exit
fi

tarball=$(basename "$1")
app="${tarball%.tar.gz}"

echo "Decompressing $1 to $SYMC_HOME"
# In some environments, sudo -u results in no access to files in home directories
# so copy tarball to /tmp and decompress it from there
cp "$1" /tmp
sudo -u "$icdx_user" tar -zxf /tmp/"$tarball" -C "$SYMC_HOME"
rm /tmp/"$tarball"

echo "Installing $app"
sudo -u "$icdx_user" -- sh -c \
  'cd $SYMC_HOME/'"$app"' ; $SYMC_HOME/launcher_dx-*/bin/launcher_dx -c installer.json'

app_without_version="${app%%-*}"

sudo -u "$icdx_user" -- bash -s "$app" "$app_without_version" <<'EOF'
    set -e

    app=$1
    app_without_version=$2

    for app_dir in "$SYMC_HOME/$app_without_version"-*; do
        if [[ "$app_dir" != "$SYMC_HOME/$app" ]]; then
            echo "Removing prior version: $app_dir"
            rm -rf "$app_dir"
            echo "    NOTE: The application was updated. Running instances of this application"
            echo "          should be restarted in the ICDx web console."
        fi
    done
EOF

echo "Install complete"
